<?php
/*
Plugin Name:单篇文章屏蔽搜索引擎收录
Plugin slug :themepar-no-index
Plugin URI:http://www.themepark.com.cn
Description:wordpress的一个小功能插件，可以让单篇文章禁止搜索引擎收录
Version: 1.0
Author: WEB主题公园
Author URI: http://www.themepark.com.cn
*/

/* plugin-update-checker */
function themepar_no_index_box() {
 if (function_exists('add_meta_box')) {  
  add_meta_box('themepar_no_index', '禁止搜索引擎收录', 'themepar_no_index', 'post', 'side', 'low');
  add_meta_box('themepar_no_index', '禁止搜索引擎收录', 'themepar_no_index', 'page', 'side', 'low');
 }
}
add_action('add_meta_boxes', 'themepar_no_index_box');
 
function themepar_no_index() {
 global $post;
  
 //添加验证字段
 wp_nonce_field('themepar_no_index', 'themepar_no_index_nonce');
  
 $meta_value = get_post_meta($post->ID, 'themepar_no_index', true);
 if($meta_value)
  echo '<input name="themepar_no_index" type="checkbox" checked="checked" value="1" /> 建议搜索引擎不收录此文章<br /><br /><a target="_blank"  href="http://www.themepark.com.cn">如何集成到主题？</a><br /><br />
<a target="_blank"  href="http://www.themepark.com.cn">更多实用资源</a>';
 else
  echo '<input name="themepar_no_index" type="checkbox" value="1" /> 建议搜索引擎不收录此文章<br /><br />
<a target="_blank"  href="http://www.themepark.com.cn">如何集成到主题？</a><br /><br />
<a target="_blank"  href="http://www.themepark.com.cn">更多实用资源</a>';
  
}
 
// 保存选项设置
function ludouse_save_postdata($post_id) {
 // 验证
 if ( !isset( $_POST['themepar_no_index_nonce']))
  return $post_id;
 
 $nonce = $_POST['themepar_no_index_nonce'];
 
 // 验证字段是否合法
 if (!wp_verify_nonce( $nonce, 'themepar_no_index'))
  return $post_id;
 
 // 判断是否自动保存
 if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) 
   return $post_id;
 
 // 验证用户权限
 if ('page' == $_POST['post_type']) {
  if ( !current_user_can('edit_page', $post_id))
   return $post_id;
 }
 else {
  if (!current_user_can('edit_post', $post_id))
   return $post_id;
 }
  
 // 更新设置
 if(!empty($_POST['themepar_no_index']))
  update_post_meta($post_id, 'themepar_no_index', '1');
 else
  update_post_meta($post_id, 'themepar_no_index', '0');
}
add_action('save_post', 'ludouse_save_postdata');
 
// 对于设置不允许抓取文章和页面
// 禁止搜索引擎抓取，返回404
function do_themepar_no_index() {
 // 本功能只对文章和页面有效
 if(is_singular()) {
  global $post;
  $is_robots = 0;
  $themepar_no_index = get_post_meta($post->ID, 'themepar_no_index', true);
 
  if(!empty($themepar_no_index)) {

   echo "<meta name=\"robots\" content=\"noindex,noarchive\" />\n";
   
  }
 }
}
add_action('wp_head', 'do_themepar_no_index');